<?php

namespace App\Http\Controllers\Api;

use App\Models\Customer;
use Illuminate\Http\Request;

class CustomerController extends BaseApiController
{
    public function index()
    {
        return $this->success(Customer::all());
    }

    public function store(Request $request)
    {
        $customer = Customer::create($request->all());
        return $this->success($customer, 'Customer created successfully');
    }

    public function show(Customer $customer)
    {
        return $this->success($customer->load('installmentPlans'));
    }

    public function update(Request $request, Customer $customer)
    {
        $customer->update($request->all());
        return $this->success($customer, 'Customer updated successfully');
    }

    public function destroy(Customer $customer)
    {
        $customer->delete();
        return $this->success(null, 'Customer deleted successfully');
    }
}
