<?php

namespace App\Http\Controllers\Api;

use App\Models\Installment;
use Illuminate\Http\Request;

class InstallmentController extends BaseApiController
{
    public function index()
    {
        return $this->success(Installment::with('plan')->get());
    }

    public function store(Request $request)
    {
        $installment = Installment::create($request->all());
        return $this->success($installment, 'Installment created successfully');
    }

    public function show(Installment $installment)
    {
        return $this->success($installment->load('plan'));
    }

    public function update(Request $request, Installment $installment)
    {
        $installment->update($request->all());
        return $this->success($installment, 'Installment updated successfully');
    }

    public function destroy(Installment $installment)
    {
        $installment->delete();
        return $this->success(null, 'Installment deleted successfully');
    }
}
