<?php

namespace App\Http\Controllers\Api;

use App\Models\InstallmentPlan;
use Illuminate\Http\Request;

class InstallmentPlanController extends BaseApiController
{
    public function index()
    {
        $plans = InstallmentPlan::with(['property', 'customer', 'installments'])->get();
        return $this->success($plans);
    }

    public function store(Request $request)
    {
        $plan = InstallmentPlan::create($request->all());
        return $this->success($plan, 'Installment plan created successfully');
    }

    public function show(InstallmentPlan $installmentPlan)
    {
        return $this->success($installmentPlan->load('property', 'customer', 'installments'));
    }

    public function update(Request $request, InstallmentPlan $installmentPlan)
    {
        $installmentPlan->update($request->all());
        return $this->success($installmentPlan, 'Installment plan updated successfully');
    }

    public function destroy(InstallmentPlan $installmentPlan)
    {
        $installmentPlan->delete();
        return $this->success(null, 'Installment plan deleted successfully');
    }
}
