<?php

namespace App\Http\Controllers\Api;

use app\Http\Requests\StoreLandloardPaymentRequest;
use app\Http\Requests\UpdateLandloardPaymentRequest;
use app\Http\Resources\LandloardPaymentResource;
use App\Models\LandloardPayment;
use Illuminate\Http\Request;

class LandloardPaymentController extends BaseApiController
{
    public function index()
    {
        $payments = LandloardPayment::with('landloard')->latest()->paginate(10);
        return $this->success($payments, 'Landloard payments retrieved successfully.');
    }

    public function store(StoreLandloardPaymentRequest $request)
    {
        $payment = LandloardPayment::create($request->validated());
        return $this->success(new LandloardPaymentResource($payment), 'Landloard payment created successfully.', 201);
    }

    public function show(LandloardPayment $landloardPayment)
    {
        $landloardPayment->load('landloard');
        return $this->success(new LandloardPaymentResource($landloardPayment), 'Landloard payment retrieved successfully.');
    }

    public function update(UpdateLandloardPaymentRequest $request, LandloardPayment $landloardPayment)
    {
        $landloardPayment->update($request->validated());
        $landloardPayment->load('landloard');
        return $this->success(new LandloardPaymentResource($landloardPayment), 'Landloard payment updated successfully.');
    }

    public function destroy(LandloardPayment $landloardPayment)
    {
        $landloardPayment->delete();
        return response()->json(null, 204);
    }
}