<?php

namespace App\Http\Controllers\Api;

use App\Models\Property;
use Illuminate\Http\Request;

class PropertyController extends BaseApiController
{
    public function index()
    {
        $properties = Property::with('project')->get();
        return $this->success($properties);
    }

    public function store(Request $request)
    {
        $property = Property::create($request->all());
        return $this->success($property, 'Property added successfully');
    }

    public function show(Property $property)
    {
        return $this->success($property->load('project', 'installmentPlans'));
    }

    public function update(Request $request, Property $property)
    {
        $property->update($request->all());
        return $this->success($property, 'Property updated successfully');
    }

    public function destroy(Property $property)
    {
        $property->delete();
        return $this->success(null, 'Property deleted successfully');
    }
}
