<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\API\BaseApiController;
use App\Http\Resources\PropertyTypeResource;
use App\Models\PropertyType;
use App\Http\Requests\StorePropertyTypeRequest;
use App\Http\Requests\UpdatePropertyTypeRequest;

class PropertyTypeController extends BaseApiController
{
    /**
     * Display a listing of the property types.
     */
    public function index()
    {
        $propertyTypes = PropertyType::get();
        return $this->success($propertyTypes, 'Property types retrieved successfully.');
    }

    /**
     * Store a newly created property type in storage.
     */
    public function store(StorePropertyTypeRequest $request)
    {
        $propertyType = PropertyType::create($request->validated());
        return $this->success(new PropertyTypeResource($propertyType), 'Property type created successfully.', 201);
    }

    /**
     * Display the specified property type.
     */
    public function show(PropertyType $propertyType)
    {
        return $this->success(new PropertyTypeResource($propertyType), 'Property type retrieved successfully.');
    }

    /**
     * Update the specified property type in storage.
     */
    public function update(UpdatePropertyTypeRequest $request, PropertyType $propertyType)
    {
        $propertyType->update($request->validated());
        return $this->success(new PropertyTypeResource($propertyType), 'Property type updated successfully.');
    }

    /**
     * Remove the specified property type from storage.
     */
    public function destroy(PropertyType $propertyType)
    {
        $propertyType->delete();
        return $this->success(null, 'Property type deleted successfully.');
    }
}