<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Project extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'id',
        'entry_date',
        'manual_no',
        'name',
        'known_as',
        'type',
        'landloard_id',
        'land_cost',
        'address',
        'completion_year',
        'square_feet_per_marla',
        'current_phase',
        'description',
        'reference_no',
        'created_by',
        'updated_by',
        'source_ip',
        'source_mac',
        'created_at',
        'updated_at'
    ];

    public function landLoard()
    {
        return $this->belongsTo(LandLoard::class);
    }

    public function properties()
    {
        return $this->hasMany(Property::class);
    }
}
