<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Property extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'project_id', 'property_type', 'title', 'unit_number',
        'area', 'area_unit', 'rooms', 'washrooms', 'is_sold', 'price',
        'created_by', 'updated_by', 'source_ip', 'source_mac'
    ];

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function installmentPlans()
    {
        return $this->hasMany(InstallmentPlan::class);
    }
}
