<?php

namespace App\Traits;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;

trait HasAuditFields
{
    public static function bootHasAuditFields()
    {
        static::creating(function ($model) {
            $user = Auth::user();
            $request = request();

            $model->created_by = $user?->id;
            $model->updated_by = $user?->id;
            $model->source_ip = $request->ip() ?? null;
            $model->source_mac = $request->header('X-Client-MAC') ?? null;
        });

        static::updating(function ($model) {
            $user = Auth::user();
            $request = request();

            $model->updated_by = $user?->id;
            $model->source_ip = $request->ip() ?? $model->source_ip;
            $model->source_mac = $request->header('X-Client-MAC') ?? $model->source_mac;
        });
    }
}
