<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class BookingSeeder extends Seeder
{
    public function run(): void
    {
        $properties = DB::table('properties')->pluck('id')->toArray();
        $customers = DB::table('customers')->pluck('id')->toArray();
        
        for ($i = 1; $i <= 20; $i++) {
            $totalPrice = rand(1000000, 50000000);
            $downPayment = $totalPrice * 0.2; // 20% down payment
            $installmentAmount = ($totalPrice - $downPayment) / rand(12, 60); // 1-5 years installment plan
            
            DB::table('bookings')->insert([
                'property_id' => $properties[array_rand($properties)],
                'customer_id' => $customers[array_rand($customers)],
                'date' => now()->subDays(rand(1, 365)),
                'manual_booking_no' => 'MB-' . str_pad($i, 4, '0', STR_PAD_LEFT),
                'booking_no' => $i,
                'from_bvn_no' => 'BVN-' . str_pad($i, 4, '0', STR_PAD_LEFT),
                'salesman' => 'Salesman ' . rand(1, 5),
                'salesman_commission' => $totalPrice * 0.01, // 1% commission
                'dealer' => 'Dealer ' . rand(1, 3),
                'next_to_kin' => 'Next of Kin ' . $i,
                'status' => ['active', 'cancelled', 'completed'][array_rand(['active', 'cancelled', 'completed'])],
                'is_verified' => rand(0, 1),
                'measurement_charges' => rand(5000, 50000),
                'total_price' => $totalPrice,
                'down_payment' => $downPayment,
                'installment_amount' => $installmentAmount,
                'start_date' => now()->subDays(rand(1, 365)),
                'description' => 'Sample booking ' . $i,
                'reference_no' => 'REF-' . Str::random(8),
                'created_by' => 1,
                'updated_by' => 1,
                'source_ip' => '127.0.0.1',
                'source_mac' => '00:00:00:00:00:00',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}