<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class LandloardSeeder extends Seeder
{
    public function run(): void
    {
        $landloards = [
            ['name' => 'Ahmed Properties', 'cnic' => '3520212345671', 'phone' => '03001234567', 'email' => 'ahmed@property.com', 'address' => '123 Main Street, Lahore'],
            ['name' => 'Bilal Developers', 'cnic' => '3520212345672', 'phone' => '03001234568', 'email' => 'bilal@developers.com', 'address' => '456 Garden Road, Islamabad'],
            ['name' => 'Chaudhary Builders', 'cnic' => '3520212345673', 'phone' => '03001234569', 'email' => 'chaudhary@builders.com', 'address' => '789 Park Avenue, Karachi'],
            ['name' => 'Dawood Enterprises', 'cnic' => '3520212345674', 'phone' => '03001234570', 'email' => 'dawood@enterprises.com', 'address' => '321 Business Center, Faisalabad'],
            ['name' => 'Ejaz Holdings', 'cnic' => '3520212345675', 'phone' => '03001234571', 'email' => 'ejaz@holdings.com', 'address' => '654 Commercial Area, Peshawar'],
            ['name' => 'Farooq Group', 'cnic' => '3520212345676', 'phone' => '03001234572', 'email' => 'farooq@group.com', 'address' => '987 Industrial Zone, Multan'],
            ['name' => 'Gulzar Properties', 'cnic' => '3520212345677', 'phone' => '03001234573', 'email' => 'gulzar@property.com', 'address' => '147 Market Street, Quetta'],
            ['name' => 'Haroon Developers', 'cnic' => '3520212345678', 'phone' => '03001234574', 'email' => 'haroon@developers.com', 'address' => '258 Plaza Road, Sialkot'],
            ['name' => 'Iqbal Builders', 'cnic' => '3520212345679', 'phone' => '03001234575', 'email' => 'iqbal@builders.com', 'address' => '369 City Center, Gujranwala'],
            ['name' => 'Jamil Holdings', 'cnic' => '3520212345680', 'phone' => '03001234576', 'email' => 'jamil@holdings.com', 'address' => '741 Mall Road, Rawalpindi'],
        ];

        foreach ($landloards as $landloard) {
            DB::table('landloards')->insert([
                'name' => $landloard['name'],
                'cnic' => $landloard['cnic'],
                'phone' => $landloard['phone'],
                'email' => $landloard['email'],
                'address' => $landloard['address'],
                'is_active' => true,
                'description' => 'Sample landloard for ' . $landloard['name'],
                'reference_no' => 'REF-' . Str::random(8),
                'created_by' => 1,
                'updated_by' => 1,
                'source_ip' => '127.0.0.1',
                'source_mac' => '00:00:00:00:00:00',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}