<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class ProjectSeeder extends Seeder
{
    public function run(): void
    {
        $landloards = DB::table('landloards')->pluck('id')->toArray();
        
        $projects = [
            ['name' => 'Clock Plaza', 'known_as' => 'GhantaGhr', 'type' => 'Shoping Mall', 'completion_year' => 2025, 'square_feet_per_marla' => 272],
            ['name' => 'Al Madev Center', 'known_as' => 'AMC', 'type' => 'Shoping Mall', 'completion_year' => 2024, 'square_feet_per_marla' => 272],
            ['name' => 'Vienna Heights', 'known_as' => 'VH', 'type' => 'Shopping Mall', 'completion_year' => 2026, 'square_feet_per_marla' => 272],
            ['name' => 'Boluvard Heights', 'known_as' => 'BH', 'type' => 'Office Buildings', 'completion_year' => 2025, 'square_feet_per_marla' => 272],
            ['name' => 'Tech Park Offices', 'known_as' => 'TPO', 'type' => 'Office Building', 'completion_year' => 2024, 'square_feet_per_marla' => 272],
            ['name' => 'Lakeside Residency', 'known_as' => 'LR', 'type' => 'Housing Society', 'completion_year' => 2026, 'square_feet_per_marla' => 272],
            ['name' => 'Downtown Plaza', 'known_as' => 'DP', 'type' => 'Shopping Mall', 'completion_year' => 2025, 'square_feet_per_marla' => 272],
            ['name' => 'Mountain View Villas', 'known_as' => 'MVV', 'type' => 'Housing Society', 'completion_year' => 2027, 'square_feet_per_marla' => 272],
            ['name' => 'Industrial Complex', 'known_as' => 'IC', 'type' => 'Industrial Park', 'completion_year' => 2024, 'square_feet_per_marla' => 272],
            ['name' => 'Riverside Apartments', 'known_as' => 'RA', 'type' => 'Apartment Building', 'completion_year' => 2025, 'square_feet_per_marla' => 272],
        ];

        foreach ($projects as $index => $project) {
            DB::table('projects')->insert([
                'entry_date' => now()->subDays(rand(1, 365)),
                'manual_no' => 'MAN-' . str_pad($index + 1, 4, '0', STR_PAD_LEFT),
                'name' => $project['name'],
                'known_as' => $project['known_as'],
                'type' => $project['type'],
                'landloard_id' => $landloards[array_rand($landloards)],
                'land_cost' => rand(1000000, 50000000),
                'address' => 'Sample address for ' . $project['name'],
                'completion_year' => $project['completion_year'],
                'square_feet_per_marla' => $project['square_feet_per_marla'],
                'current_phase' => 'Phase ' . rand(1, 3),
                'description' => 'Sample project for ' . $project['name'],
                'reference_no' => 'REF-' . Str::random(8),
                'created_by' => 1,
                'updated_by' => 1,
                'source_ip' => '127.0.0.1',
                'source_mac' => '00:00:00:00:00:00',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}