<?php 
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

// use App\Http\Controllers\Api\AuthController;


use App\Http\Controllers\Api\{
    AuthController,
    LandloardController,
    ProjectController,
    PropertyTypeController,
    // BookingController,
    // CustomerController,
    // CustomerPaymentController,
    // InstallmentController,
    
    // LandloardPaymentController,
    // LandloardPaymentScheduleController,
    // PropertyController,
    
};

// Public Routes (for authentication)
Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);

// Protected Routes (require authentication)
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout']);

    // API Resources for all tables
    Route::apiResource('landloards', LandloardController::class);
    Route::apiResource('projects', ProjectController::class);
    Route::apiResource('property-types', PropertyTypeController::class); // Using kebab-case for URLs
    
    // Route::apiResource('properties', PropertyController::class);
    // Route::apiResource('customers', CustomerController::class);
    // Route::apiResource('bookings', BookingController::class);
    // Route::apiResource('installments', InstallmentController::class);
    // Route::apiResource('customer-payments', CustomerPaymentController::class);
    // Route::apiResource('landloard-payment-schedules', LandloardPaymentScheduleController::class);
    // Route::apiResource('landloard-payments', LandloardPaymentController::class);
});

